#include "IPhysicalBody.h"

namespace PhysicsEngine
{

IPhysicalBody::IPhysicalBody()
{
}

IPhysicalBody::IPhysicalBody(int objectid, int materialid, float mass, Vector3f position, Vector3f rotation):IPhysicalObject(objectid)
{
	this->materialid = materialid;
	this->mass = mass;
	this->position = position;
	this->rotation = rotation;
	
}

IPhysicalBody::~IPhysicalBody()
{
}

int IPhysicalBody::GetMaterialId()
{
	return materialid;
}

float IPhysicalBody::GetMass()
{
	return mass;
}

Vector3f IPhysicalBody::GetPosition()
{
	return position;
}

Vector3f IPhysicalBody::GetRotation()
{
	return rotation;
}

DataQuaternion IPhysicalBody::GetQuaternion()
{
	return quaternion;
}

void IPhysicalBody::SetMaterialId(int value)
{
	this->materialid = value;
}

void IPhysicalBody::SetMass(float mass)
{
	this->mass= mass;
}

void IPhysicalBody::SetPosition(Vector3f value)
{
	this->position = value;
}

void IPhysicalBody::SetRotation(Vector3f value)
{
	this->rotation = value;
}

void IPhysicalBody::SetQuaternion(DataQuaternion value)
{
	this->quaternion = value;
}

DataObject *IPhysicalBody::GetDataObject()
{
	return this->GetDataBody();
}


}
